//////////////////////////////////////////////////////////
//
// Filename: tms.h
// Author:   Stefan (Shaderman) Greven
// Date:     29.12.2009
//
// Description: This is the header of the main
//              Torque Master Server code
//
//////////////////////////////////////////////////////////

#ifndef TMS_H_INCLUDED
#define TMS_H_INCLUDED

#include <string>

#include "sip_store.h"
#include "packet.h"

#include <boost/asio.hpp>
#include <boost/bind.hpp>
#include <boost/thread.hpp>

using boost::asio::ip::udp;

enum PACKETTYPES
{
    MasterServerGameTypesRequest    = 2,    // 0x02
    MasterServerGameTypesResponse   = 4,    // 0x04
    MasterServerListRequest         = 6,    // 0x06
	MasterServerListResponse	    = 8,	// 0x08
	GameMasterInfoRequest		    = 10,	// 0x0A
	GameMasterInfoResponse		    = 12,   // 0x0C
	GameHeartbeat			        = 22	// 0x16
};

// Server Query Filter Packet
//    packetIndex       Request specific page # (rest empty)
//    gameType          Game type string
//    missionType       Mission type string
//    minPlayers        At least this many players
//    maxPlayers        No more than this many
//    regions           Region mask, 0 = all
//    version           Server version, 0 = any
//    filterFlags       Server flags (dedicated, etc), 0 = any
//    maxBots           No more than maxBots
//    minCPUSpeed       At least this fast
//    playerCount       Buddy list search
//    playerList[playerCount]

class CMaster
{
private:
    // SIP STORE
    CSipStore m_sipStore;

    // NETWORKING
    boost::asio::io_service&    m_socketIos;
    udp::socket                 m_socket;
    udp::endpoint               m_sender_endpoint;
    const char*                 m_sender_ip;
    U32                         m_sender_port;

    Packet                      m_packet;

    void checkPacket(const boost::system::error_code& error, size_t bytes_recvd);
    void handleHeartbeat(std::string ip, U32 port);
    void sendInfoRequest(std::string ip, U32 port);
    void handleGameTypesRequest();
    void sendGameTypesResponse();
    void handleInfoResponse(std::string ip, U32 port);
    void handleServerListRequest();
    void sendServerList(U16 session, U16 key, std::multimap<std::string, U16> addresses, U8 index);
    void packetSent(const boost::system::error_code& /*error*/, size_t /*bytes_sent*/);

    // HELPER FUNCTIONS
    U32  getRandU32();
    U32  getIp(std::string ip);
    U16  swapU16(U16 port);

    // CLEANUP TIMER
    boost::asio::deadline_timer m_cleanupTimer;
    void runCleanup();

    // EXEC TIMER
    boost::asio::deadline_timer m_execTimer;
    void runExec();

    #if defined(MASTER_DEBUG)
    void addFakeServers(S32 num);
    #endif // DEBUG

public:
    CMaster(CSipStore& sip_store, boost::asio::io_service& ios_socket, boost::asio::io_service& ios_cleanupTimer,
            boost::asio::io_service& ios_execTimer, boost::asio::ip::address ip_addr, short port);
};

#endif
