.TH tms 1 "April 5, 2010" "" "Torque Master Server"

.SH NAME
tms \- A Master Server for Torque game engines

.SH SYNOPSIS
.B tms
.RI [ options ]
.br

.SH DESCRIPTION
The Torque Master Server
.B tms
is a meeting place for Torque game servers and clients. When a Torque game server is started, it sends continuous heartbeats to the master server containing information about the game type it offers, if a password is needed to connect etc. A game client can query the master server with a game type and receives a list of matching servers. A game client can then connect to one of those returned servers.

.SH NOTES
Command line options have a higher priority than config file options!

.SH OPTIONS
.SS Generic
.TP
.B --version (-v)
Shows the program version
.TP
.B --help (-h)
Show a list of possible program options
.SS Networking
.TP
.B --address (-a) <ip>
Listen on IP address <ip>
.TP
.B --port (-p) <port>
Listen on port <port>
.SS Execution
.TP
.B --configfile (-c) <file>
Use parameters from config file <file>
.TP
.B --daemonuser (-d) <user>
Make the master server a daemon that runs as user <user>. Logging to file and console will be disabled.
.TP
.B --purge (-u) <int>
When <int> = 1, the SQLite database will be purged on start. The defaults is 0: Don't purge and use the stored servers.
.SS Logging
.TP
.B --logfile (-f) <file>
Log to file <file>. This option is disabled when the master server is run as daemon.
.TP
.B --loglevel (-o) <int>
Possible values for <int> are 1 for normal logging and 2 for more verbose logging. Defaults is 1 (normal logging).
.TP
.B --syslog (-s) <host>
Enables logging to either a local or remote syslog server <host> on UDP port 514.
.SS Execution timer
.TP
.B --exec (-e) <file>
Execute script or program <file> every 5 (default) minutes. Following values will be passed to the script or program on execution:
.RS 7
.TP
- The current Unix/POSIX time
.TP
- The number of current servers
.TP
- The number of current players (total on all servers)
.TP
- The number of current bots (total on all servers)
.RE
.RS 7

See option 
.B --execinterval 
below on how to change the execution interval.
.RE
.TP
.B --execinterval (-t) <int>
The interval <int> in minutes for the execution of an external script or program. Defaults to 5 minutes. See option
.B --exec
above to get more information about executing a script or program.
.SS Server list
.TP
.B --interval (-i) <int>
The interval <int> in seconds after which dead servers will be removed from the server list. Defaults to 120 seconds.
.TP
.B --lifetime (-l) <int>
The lifetime <int> when servers are considered dead (didn't send a heartbeat). Defaults to 180 seconds.

.SH AUTHOR
This manpage was written by Stefan (Shaderman) Greven <torquemaster@shaderman.com>.