//////////////////////////////////////////////////////////
//
// Filename: packet.h
// Author:   Stefan (Shaderman) Greven
// Date:     06.01.2010
//
// Description: This is the header of a data packet class
//
//////////////////////////////////////////////////////////

#ifndef PACKET_H_INCLUDED
#define PACKET_H_INCLUDED

#include "main.h"

#include <string>

#include <boost/array.hpp>

class Packet : public boost::array<char, TMS_PACKET_SIZE>
{
private:
    iterator m_iter;
    int             m_packetSize;

    unsigned char   m_highHighByte;
    unsigned char   m_highByte;
    unsigned char   m_highLowByte;
    unsigned char   m_lowByte;

public:
    Packet();

    unsigned char   readU8();
    signed char     readS8();
    unsigned short  readU16();
    signed short    readS16();
    unsigned int    readU32();
    signed int      readS32();
    std::string     readString();

    void            prepare();
    void            writeU8(unsigned char data);
    void            writeS8(signed char data);
    void            writeU16(unsigned short data);
    void            writeS16(signed short data);
    void            writeU32(unsigned int data);
    void            writeS32(signed int data);
    void            writeString(std::string data);

    int             getPacketSize();
};

#endif // PACKET_H_INCLUDED
