//////////////////////////////////////////////////////////
//
// Filename: packet.cpp
// Author:   Stefan (Shaderman) Greven
// Date:     06.01.2010
//
// Description: This is a data packet class
//
//////////////////////////////////////////////////////////

#include "packet.h"

#include <cstring>

Packet::Packet()
{
    m_iter = begin();
    m_packetSize = 0;
}

unsigned char Packet::readU8()
{
    unsigned char res   = *m_iter++;

    return res;
}

signed char Packet::readS8()
{
    signed char res     = *m_iter++;

    return res;
}

unsigned short Packet::readU16()
{
    m_highByte          = *m_iter++;
    m_lowByte           = *m_iter++;
    unsigned short res  = (m_highByte << 8) | m_lowByte;

    return res;
}

signed short Packet::readS16()
{
    m_highByte          = *m_iter++;
    m_lowByte           = *m_iter++;
    signed short res    = (m_highByte << 8) | m_lowByte;

    return res;
}

unsigned int Packet::readU32()
{
    m_highHighByte      = *m_iter++;
    m_highByte          = *m_iter++;
    m_highLowByte       = *m_iter++;
    m_lowByte           = *m_iter++;
    unsigned int res    = (m_highHighByte << 24) | (m_highByte << 16) | (m_highLowByte << 8) | m_lowByte;

    return res;
}

signed int Packet::readS32()
{
    m_highHighByte      = *m_iter++;
    m_highByte          = *m_iter++;
    m_highLowByte       = *m_iter++;
    m_lowByte           = *m_iter++;
    signed int res      = (m_highHighByte << 24) | (m_highByte << 16) | (m_highLowByte << 8) | m_lowByte;

    return res;
}

std::string Packet::readString()
{
    unsigned int numChars = readU8();

    std::string res;
    for (unsigned int i = 0; i < numChars; i++)
        res += *m_iter++;

    return res;
}

void Packet::writeU8(unsigned char data)
{
    *m_iter++ = data;
    m_packetSize++;
}

void Packet::writeS8(signed char data)
{
    *m_iter++ = data;
    m_packetSize++;
}

void Packet::writeU16(unsigned short data)
{
    size_t size = sizeof(unsigned short);

    unsigned char buffer[size];
    memcpy(&buffer, &data, size);

    for( ; size > 0; )
        writeU8(buffer[--size]);
}

void Packet::writeS16(signed short data)
{
    size_t size = sizeof(signed short);

    unsigned char buffer[size];
    memcpy(&buffer, &data, size);

    for( ; size > 0; )
        writeU8(buffer[--size]);
}

void Packet::writeU32(unsigned int data)
{
    size_t size = sizeof(unsigned int);

    unsigned char buffer[size];
    memcpy(&buffer, &data, size);

    for( ; size > 0; )
        writeU8(buffer[--size]);
}

void Packet::writeS32(signed int data)
{
    size_t size = sizeof(signed int);

    unsigned char buffer[size];
    memcpy(&buffer, &data, size);

    for( ; size > 0; )
        writeU8(buffer[--size]);
}

void Packet::writeString(std::string data)
{
    // get the string size
    int size = data.size();
    strncpy(m_iter, data.c_str(), size);

    m_iter += size;
    m_packetSize += size;
}

// this function needs to be called before reading or writing a package!
void Packet::prepare()
{
    m_iter = begin();
    m_packetSize = 0;
}

int Packet::getPacketSize()
{
    return m_packetSize;
}
