//////////////////////////////////////////////////////////
//
// Filename: options.h
// Author:   Stefan (Shaderman) Greven
// Date:     03.01.2010
//
// Description: Program options header
//
//////////////////////////////////////////////////////////

#ifndef OPTIONS_H_INCLUDED
#define OPTIONS_H_INCLUDED

#include "main.h"

#include <string>

struct prog_opt
{
    prog_opt()
    {
        configFile      = "";
        daemonUser      = "";
        purge           = 0;
        address         = "";
        port            = 28002;
        interval        = TMS_CLEANUPINTERVAL;
        lifetime        = TMS_SERVERLIFETIME;
        logFile         = "";
        logLevel        = 1;
        syslogHost      = "";
        exec            = "";
        execinterval    = TMS_EXECINTERVAL;
    }

    // config file
    std::string configFile;

    // daemon
    std::string daemonUser;

    // database
    int         purge;

    // logging
    std::string logFile;
    int         logLevel;
    std::string syslogHost;

    // networking
    std::string address;
    int port;

    // server list
    int interval;
    int lifetime;

    // execute
    std::string exec;
    int execinterval;
};

class COptions
{
public:
    bool checkArgs(int ac, char *av[]);
};

#endif // OPTIONS_H_INCLUDED
