#ifndef MAIN_H_INCLUDED
#define MAIN_H_INCLUDED

typedef signed char     S8;
typedef unsigned char   U8;

typedef signed short    S16;
typedef unsigned short	U16;

typedef signed int	    S32;
typedef unsigned int	U32;

// The name of the pid file used for locking
#define TMS_PID_FILE "tms.pid"

// Packet size for data transfer
#define TMS_PACKET_SIZE 1472    // 1500 byte (ethernet MTU) - 20 byte (IP header) - 8 byte (UDP header) = 1472 byte
                                // Use the command "ping -M do -s 1472 www.sometiste.com" to find out the max MTU

// How often will the server list cleanup run?
#define TMS_CLEANUPINTERVAL 120    // seconds

// When will a server be deleted from the server list?
#define TMS_SERVERLIFETIME 180  // seconds

// How often will the external program be executed?
#define TMS_EXECINTERVAL 5  // minutes

#endif // MAIN_H_INCLUDED
