//////////////////////////////////////////////////////////
//
// Filename: logging.h
// Author:   Stefan (Shaderman) Greven
// Date:     29.12.2009
//
// Description: Logging class header
//
//////////////////////////////////////////////////////////

#ifndef LOGGING_H_INCLUDED
#define LOGGING_H_INCLUDED

#include <boost/log/common.hpp>

namespace src = boost::log::sources;

enum severity_level
{
    D,  // debug
    I   // info
};

// The formatting logic for the severity level
template< typename CharT, typename TraitsT >
inline std::basic_ostream< CharT, TraitsT >& operator<< (
    std::basic_ostream< CharT, TraitsT >& strm, severity_level lvl)
{
    static const char* const str[] =
    {
        "D",
        "I",
        "E"
    };
    if (static_cast< std::size_t >(lvl) < (sizeof(str) / sizeof(*str)))
        strm << str[lvl];
    else
        strm << static_cast< int >(lvl);
    return strm;
}

static src::severity_logger< severity_level > slg;

void init_logging();

#endif // LOGGING_H_INCLUDED
